<?php

###################################################### Change tracking status ##########################################################

if(isset($_GET['tracking_id'],$_GET['tracking_status']))

{

	require_once '../config.php';

	try

	{

		$q = $pdo->prepare("UPDATE tracking SET tracking_status = ? WHERE tracking_id = ?");

		$q->bindValue(1,$_GET['tracking_status']);

		$q->bindValue(2,$_GET['tracking_id']);

		$q ->execute();

	}

	catch (PDOException $e) {echo 'Error !'.$e; exit();}



	if($q->rowCount() == 1) { echo 'done'; }

	exit();

}



###################################################### GET Property BY ID ##############################################################

if(isset($_POST['expose_id']))

{

	if(empty($_POST['expose_id']) || !is_numeric($_POST['expose_id']))

	{

		$_SESSION['error'] = 'The expose ID is incorrect. Please make sure that the Expose Id a number !'; r();

	}

	

	require_once 'simple_html_dom.php';

	

	$html = file_get_html('http://www.immobilienscout24.de/expose/printView.go?exposeId='.$_POST['expose_id'], $use_include_path = false, $context=null, $offset = -1, $maxLen=-1, $lowercase = true, $forceTagsClosed=true, $target_charset = DEFAULT_TARGET_CHARSET, $stripRN=false, $defaultBRText=DEFAULT_BR_TEXT);

	

	if(!isset($html) || $html === false)

	{

		$_SESSION['error'] = 'Error: Object with Scout ID <span>"'.$_POST['expose_id'].'"</span> not found. Please check this page: <a href="http://www.immobilienscout24.de/expose/printView.go?exposeId='.$_POST['expose_id'].'" target="_blank">http://www.immobilienscout24.de/expose/printView.go?exposeId='.$_POST['expose_id'].'</a>'; r();

	}

	elseif($html->find('title',0)->plaintext == 'Objekt nicht gefunden')

	{

		$_SESSION['error'] = 'Error: Object with Scout ID <span>"'.$_POST['expose_id'].'"</span> not found. Please check this page: <a href="http://www.immobilienscout24.de/expose/printView.go?exposeId='.$_POST['expose_id'].'" target="_blank">http://www.immobilienscout24.de/expose/printView.go?exposeId='.$_POST['expose_id'].'</a>'; r();

	}



	// Find all article blocks

	$elements = array(

		'property_rent' => 'dd.is24qa-kaltmiete',

		'property_price' => 'dd.is24qa-kaufpreis',

		'property_detail_title' => 'header.page-header',

		'property_detail_address' => 'div.is24-print-anbieter-info div.margin-bottom',

		'property_detail_city' => 'div.is24-print-anbieter-info div.margin-bottom',

		'property_detail_size' => 'dd.is24qa-wohnflaeche-ca',

		'property_detail_type' => 'dd.is24qa-wohnungstyp',

		'property_detail_rooms' => 'dd.is24qa-zimmer',

		'property_detail_floor' => 'dd.is24qa-etage',

		'property_detail_floors' => 'dd.is24qa-etagenanzahl',

		'property_detail_bedrooms' => 'dd.is24qa-schlafzimmer',

		'property_detail_bathrooms' => 'dd.is24qa-badezimmer',

		'property_detail_balcony_terrace' => 'dd.is24qa-balkon-terrasse span.fa',

		'property_detail_garden' => 'dd.is24qa-garten-mitbenutzung span.fa',

		'property_detail_basement' => 'dd.is24qa-keller span.fa',

		'property_detail_elevator' => 'dd.is24qa-personenaufzug span.fa',

		'property_detail_garage' => 'dd.is24qa-garage-stellplatz',

		'property_detail_year_built' => 'dd.is24qa-baujahr',

		'property_detail_renovated' => 'dd.is24qa-letzte-modernisierung-sanierung',

		'property_description' => 'p.is24qa-objektbeschreibung',

		'property_furnishing' => 'p.is24qa-ausstattung',

		'property_location' => 'p.is24qa-lage',

	);

		

	foreach($elements as $element_key => $element_selector)

	{

		if($element_key == 'property_price') {$k = 1;} else { $k = 0; }

		

		if($html->find($element_selector, $k))

		{

			if(strpos($element_selector,'span.fa') !== false)

			{

				$p[$element_key] = 'Yes';

			}

			else

			{

				$p[$element_key] = $html->find($element_selector, $k)->plaintext;

			}

		}

	}

	

	/*** PROPERTY ADDRESS ***/

	$p['property_detail_address'] = str_replace(' Die vollständige Adresse der Immobilie erhalten Sie vom Anbieter.','',$p['property_detail_address'],$count_replaces);

	if($count_replaces == 1)

	{

		$_SESSION['error'] = "Error: The address for Object <span>".$_POST['expose_id']."</span> is incomplete !"; r();

	}

	

	/*** PROPERTY SIZE ***/

	$p['property_detail_size'] = str_replace(' m²','',$p['property_detail_size']);

	

	/*** PROPERTY ROOMS ***/

	$p['property_detail_rooms'] = str_replace('.00','',$p['property_detail_rooms']);

	

	/*** PROPERTY IMAGES ***/

	$p['property_images'] = array();

	foreach($html->find('#is24-print-gallery img') as $element)

	{

		$img = $element->src;

		$img = explode('ORIG',$img);

		$img = substr($img[0],0,-1);

		array_push($p['property_images'],$img);

	}

		

	/*** PROPERTY FLOOR PLANS ***/

	$p['property_floor_images'] = array();

	foreach($html->find('#is24-print-floorplan img') as $element)

	{

		$img = $element->src;

		$img = explode('ORIG',$img);

		$img = substr($img[0],0,-1);

		array_push($p['property_floor_images'],$img);

	}

	

	$html = file_get_html('http://www.immobilienscout24.de/expose/'.$_POST['expose_id'], $use_include_path = false, $context=null, $offset = -1, $maxLen=-1, $lowercase = true, $forceTagsClosed=true, $target_charset = DEFAULT_TARGET_CHARSET, $stripRN=false, $defaultBRText=DEFAULT_BR_TEXT);

	

	

	/*** PROPERTY FLOOR PLANS PDF ***/

	$p['property_floor_pdf'] = array();

	if(empty($p['property_floor_images']))

	{

		if($html->find('.is24-ex-floorplan a.is24-pdf'))

		{

			foreach($html->find('.is24-ex-floorplan a.is24-pdf') as $element)

			{

				$pdf = $element->href;

				$pdf = explode('?',$pdf);

				$pdf = $pdf[0];

				if($pdf != '#') {array_push($p['property_floor_pdf'],$pdf);}

			}

		}

	}

	

	$p['property_detail_address'] = $html->find('[data-qa=is24-expose-address] strong',0)->innertext;

	$p['property_detail_city'] = str_replace($p['property_detail_address'],'',$html->find('[data-qa=is24-expose-address]',0)->innertext);

	$p['property_detail_city'] = str_replace($html->find('[data-qa=is24-expose-address] a',0)->plaintext,'',$p['property_detail_city']);

	$p['property_detail_city'] = str_replace($html->find('[data-qa=is24-expose-address] a',1)->plaintext,'',$p['property_detail_city']);

	$p['property_detail_city'] = strip_tags($p['property_detail_city']);

	

	

	foreach($elements as $element_key => $element_selector)

	{

		if($element_key != 'property_description' && $element_key != 'property_furnishing' && $element_key != 'property_location' && isset($p[$element_key]))

		{

			$p[$element_key] = preg_replace('!\s+!', ' ',$p[$element_key]);

			if(substr($p[$element_key],0,1) == ' ')

			{

				$p[$element_key] = substr($p[$element_key],1);

			}

			if(substr($p[$element_key],-1) == ' ')

			{

				$p[$element_key] = substr($p[$element_key],0,-1);

			}

		}

	}

	

	/*** PROPERTY TYPE ***/

	$p['property_type'] = $_POST['expose_type'];

	

	/*** PROPERTY PRICE ***/

	if(str_replace(' ','',$p['property_price']) == '') {$p['property_price'] = $p['property_rent'];}

	else { unset($s['is24_price_multiple']); }

	$property_price = $p['property_price'];

	$property_price = explode(' ',$property_price);

	$property_price = $property_price[0];

	$property_price = explode('.',$property_price);

	$property_price = $property_price[0];

	$property_price = str_replace(',','',$property_price);

	if(isset($s['is24_price_multiple'])) {$property_price = $property_price * $s['is24_price_multiple']; }

	$p['property_price'] = number_format($property_price , 0, ',', '.').',00';

	

	/*** PROPERTY RENT ***/



	if(str_replace(' ','',$p['property_rent']) == '') {$p['property_rent'] = $p['property_price'];}

	$property_rent = $p['property_rent'];

	$property_rent = explode(' ',$property_rent);

	$property_rent = $property_rent[0];

	$p['property_rent'] = $property_rent;

	

	/*** ADDRESS ***/

	$address = explode(' ',$p['property_detail_address']);

	$p['property_detail_street'] = str_replace(' '.end($address),'',$p['property_detail_address']);

	$p['property_detail_street_nr'] = end($address);

	

	$city = explode(' ',$p['property_detail_city']);

	$p['property_detail_post_code'] = $city[0];

	$p['property_detail_city'] = $city[1];

	if(isset($city[2])) {$p['property_detail_city'] .= ' '.$city[2];}

	$p['property_detail_address'] = implode(' ',$address).', '.implode(' ',$city);

	

	/*** PROPERTY NAME ***/

	$p['property_name'] = 'Property for sale in: '.$p['property_detail_address'];

	

	$_SESSION['p'] = $p;

	$_SESSION['p']['expose_id'] = $_POST['expose_id'];

	

	r();

}



if(isset($_SESSION['p']) && !empty($_SESSION['p'])) {$p = $_SESSION['p'];}

if(@$_GET['do'] != 'add') {unset($_SESSION['p']);}



	

######################################################## Add Property ##################################################################

if(isset($_POST['add_property_here']) || isset($_POST['add_property_properties']))

{

	if(empty($_POST['property_slide'])) { $_POST['property_slide'] = '';}

	

	$property_tracking = time();

	$property_tracking = substr($property_tracking,2);

	try

	{

		$q = $pdo->prepare("INSERT INTO properties ( property_name, property_tracking, property_price, property_rent, property_agent, property_status, property_slide, property_description, property_furnishing, property_location, property_detail_title, property_detail_street, property_detail_street_nr, property_detail_city, property_detail_post_code, property_detail_bedrooms, property_detail_owner, property_detail_elevator, property_detail_size, property_detail_floor, property_detail_floors, property_detail_basement, property_detail_balcony_terrace, property_detail_garden, property_detail_rooms, property_detail_year_built, property_detail_renovated, property_detail_garage, property_detail_furniture, property_detail_bathrooms, property_detail_type, property_detail_earnest_procent, property_detail_earnest_deposit, property_deposit, property_type, property_default, property_map ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");

		$q->bindValue(1,$_POST['property_name']);

		$q->bindValue(2,$property_tracking);

		$q->bindValue(3,$_POST['property_price']);

		$q->bindValue(4,$_POST['property_rent']);

		$q->bindValue(5,$_POST['property_agent']);

		$q->bindValue(6,$_POST['property_status']);

		$q->bindValue(7,$_POST['property_slide']);

		$q->bindValue(8,$_POST['property_description']);

		$q->bindValue(9,$_POST['property_furnishing']);

		$q->bindValue(10,$_POST['property_location']);

		$q->bindValue(11,$_POST['property_detail_title']);

		$q->bindValue(12,$_POST['property_detail_street']);

		$q->bindValue(13,$_POST['property_detail_street_nr']);

		$q->bindValue(14,$_POST['property_detail_city']);

		$q->bindValue(15,$_POST['property_detail_post_code']);

		$q->bindValue(16,$_POST['property_detail_bedrooms']);

		$q->bindValue(17,$_POST['property_detail_owner']);

		$q->bindValue(18,$_POST['property_detail_elevator']);

		$q->bindValue(19,$_POST['property_detail_size']);

		$q->bindValue(20,$_POST['property_detail_floor']);

		$q->bindValue(21,$_POST['property_detail_floors']);

		$q->bindValue(22,$_POST['property_detail_basement']);

		$q->bindValue(23,$_POST['property_detail_balcony_terrace']);

		$q->bindValue(24,$_POST['property_detail_garden']);

		$q->bindValue(25,$_POST['property_detail_rooms']);

		$q->bindValue(26,$_POST['property_detail_year_built']);

		$q->bindValue(27,$_POST['property_detail_renovated']);

		$q->bindValue(28,$_POST['property_detail_garage']);

		$q->bindValue(29,$_POST['property_detail_furniture']);

		$q->bindValue(30,$_POST['property_detail_bathrooms']);

		$q->bindValue(31,$_POST['property_detail_type']);

		$q->bindValue(32,$_POST['property_detail_earnest_procent']);

		$q->bindValue(33,$_POST['property_detail_earnest_deposit']);

		$q->bindValue(34,$_POST['property_deposit']);

		$q->bindValue(35,$_POST['property_type']);

		$q->bindValue(36,$_POST['property_default']);

		$q->bindValue(37,$_POST['property_map']);

		$q ->execute();

	}

	catch (PDOException $e) {echo 'Error !'.$e; exit();}

	

	$id = $pdo->lastInsertId();

	

	if($q->rowCount() == 1)

	{

		$_SESSION['success'] = 'Property added !';

		if($_FILES['property_map_images']['name'][0] != '')

		{

			require_once 'upload.php';

			upload(array('image/jpeg','image/png','image/gif'),'property_map_images','../p',$id.'_map');

		}

		

		if($_FILES['property_images']['name'][0] != '')

		{

			require_once 'upload.php';

			upload(array('image/jpeg','image/png','image/gif'),'property_images','../p',$id);

		}

	

		if($_FILES['property_floor_plan']['name'][0] != '')

		{

			require_once 'upload.php';

			upload(array('image/jpeg','image/png','image/gif'),'property_floor_plan','../p',$id.'_floor');

		}

		

		if(isset($_SESSION['p']['property_images']))

		{

			$i = 0;

			foreach($_SESSION['p']['property_images'] as $img)

			{

				if(!isset($_POST['delete_images']) || (isset($_POST['delete_images']) && !in_array($img,$_POST['delete_images'])))

				{

					$i++;

					$img = @imagecreatefromstring(url_get_contents($img));

					imagealphablending($img, false);

					imagesavealpha($img, true);

					imagepng($img, '../p/'.$id.'_'.($i+20).'.png');

				}

			}

		}

		

		if(isset($_SESSION['p']['property_floor_images']))

		{

			$i = 0;

			foreach($_SESSION['p']['property_floor_images'] as $img)

			{

				if(!isset($_POST['delete_images']) || (isset($_POST['delete_images']) && !in_array($img,$_POST['delete_images'])))

				{

					$i++;

					$img = @imagecreatefromstring(url_get_contents($img));

					imagealphablending($img, false);

					imagesavealpha($img, true);

					imagepng($img, '../p/'.$id.'_floor_'.($i+20).'.png');

				}

			}

		}

		

		require_once 'p_properties_download.php';

	}

	else

	{

		$_SESSION['error'] = 'There was an error. Please try again or contact webmaster !';

	}

	

	if(isset($_POST['add_property_here'])) { r('p=properties&do=edit&id='.$id);} else { r('p=properties'); }

}





######################################################### Save Property ################################################################

if(isset($_POST['save_property_here']) || isset($_POST['save_property_properties']))

{

	if(empty($_POST['property_slide'])) { $_POST['property_slide'] = '';}

	

	if(isset($_POST['delete_images']) && !empty($_POST['delete_images']))

	{

		foreach($_POST['delete_images'] as $delete)

		{

			if(!unlink($delete))

			{

				$_SESSION['error'] = 'There was some errors in deleting selected images.';

			}

		}

	}

	

	if(isset($_POST['order_images']) && !empty($_POST['order_images']))

	{

		foreach($_POST['order_images'] as $key => $order)

		{

			if(($key+1) != $order)

			{

				foreach($_POST['order_images'] as $key => $order)

				{

					rename($_POST['order_images_url'][$key],str_replace('.png','_B.png',$_POST['order_images_url'][$key]));

				}

				foreach($_POST['order_images'] as $key => $order)

				{

					rename(str_replace('.png','_B.png',$_POST['order_images_url'][$key]),'../p/'.$_GET['id'].'_'.$order.'.png');

				}

				break;

			}

		}

	}

	

	if(isset($_POST['order_floor_images']) && !empty($_POST['order_floor_images']))

	{

		foreach($_POST['order_floor_images'] as $key => $order)

		{

			if(($key+1) != $order)

			{

				foreach($_POST['order_floor_images'] as $key => $order)

				{

					rename($_POST['order_floor_images_url'][$key],str_replace('.png','_B.png',$_POST['order_floor_images_url'][$key]));

				}

				foreach($_POST['order_floor_images'] as $key => $order)

				{

					rename(str_replace('.png','_B.png',$_POST['order_floor_images_url'][$key]),'../p/'.$_GET['id'].'_floor_'.$order.'.png');

				}

				break;

			}

		}

	}

	

	if(isset($_POST['order_map_images']) && !empty($_POST['order_map_images']))

	{

		foreach($_POST['order_map_images'] as $key => $order)

		{

			if(($key+1) != $order)

			{

				foreach($_POST['order_map_images'] as $key => $order)

				{

					rename($_POST['order_map_images_url'][$key],str_replace('.png','_B.png',$_POST['order_map_images_url'][$key]));

				}

				foreach($_POST['order_map_images'] as $key => $order)

				{

					rename(str_replace('.png','_B.png',$_POST['order_map_images_url'][$key]),'../p/'.$_GET['id'].'_map_'.$order.'.png');

				}

				break;

			}

		}

	}

	

	try

	{

		$q = $pdo->prepare("UPDATE properties SET property_name = ?, property_price = ?, property_rent = ?, property_agent = ?, property_status = ?, property_slide = ?, property_description = ?, property_furnishing = ?, property_location = ?, property_detail_title = ?, property_detail_street = ?, property_detail_street_nr = ?, property_detail_city = ?, property_detail_post_code = ?, property_detail_bedrooms = ?, property_detail_owner = ?, property_detail_elevator = ?, property_detail_size = ?, property_detail_floor = ?, property_detail_floors = ?, property_detail_basement = ?, property_detail_balcony_terrace = ?, property_detail_garden = ?, property_detail_rooms = ?, property_detail_year_built = ?, property_detail_renovated = ?, property_detail_garage = ?, property_detail_furniture = ?, property_detail_bathrooms = ?, property_detail_type = ?, property_detail_earnest_procent = ?, property_detail_earnest_deposit = ?, property_deposit = ?, property_type = ?, property_map = ?, property_default = ? WHERE property_id = ?");

		$q->bindValue(1,$_POST['property_name']);

		$q->bindValue(2,$_POST['property_price']);

		$q->bindValue(3,$_POST['property_rent']);

		$q->bindValue(4,$_POST['property_agent']);

		$q->bindValue(5,$_POST['property_status']);

		$q->bindValue(6,$_POST['property_slide']);

		$q->bindValue(7,$_POST['property_description']);

		$q->bindValue(8,$_POST['property_furnishing']);

		$q->bindValue(9,$_POST['property_location']);

		$q->bindValue(10,$_POST['property_detail_title']);

		$q->bindValue(11,$_POST['property_detail_street']);

		$q->bindValue(12,$_POST['property_detail_street_nr']);

		$q->bindValue(13,$_POST['property_detail_city']);

		$q->bindValue(14,$_POST['property_detail_post_code']);

		$q->bindValue(15,$_POST['property_detail_bedrooms']);

		$q->bindValue(16,$_POST['property_detail_owner']);

		$q->bindValue(17,$_POST['property_detail_elevator']);

		$q->bindValue(18,$_POST['property_detail_size']);

		$q->bindValue(19,$_POST['property_detail_floor']);

		$q->bindValue(20,$_POST['property_detail_floors']);

		$q->bindValue(21,$_POST['property_detail_basement']);

		$q->bindValue(22,$_POST['property_detail_balcony_terrace']);

		$q->bindValue(23,$_POST['property_detail_garden']);

		$q->bindValue(24,$_POST['property_detail_rooms']);

		$q->bindValue(25,$_POST['property_detail_year_built']);

		$q->bindValue(26,$_POST['property_detail_renovated']);

		$q->bindValue(27,$_POST['property_detail_garage']);

		$q->bindValue(28,$_POST['property_detail_furniture']);

		$q->bindValue(29,$_POST['property_detail_bathrooms']);

		$q->bindValue(30,$_POST['property_detail_type']);

		$q->bindValue(31,$_POST['property_detail_earnest_procent']);

		$q->bindValue(32,$_POST['property_detail_earnest_deposit']);

		$q->bindValue(33,$_POST['property_deposit']);

		$q->bindValue(34,$_POST['property_type']);

		$q->bindValue(35,$_POST['property_map']);

		$q->bindValue(36,$_POST['property_default']);

		$q->bindValue(37,$_GET['id']);

		$q ->execute();

	}

	catch (PDOException $e) {echo 'Error !'; exit();}

	if($q->rowCount() == 1)

	{

		try

		{

			$q = $pdo->prepare("SELECT tracking_code FROM tracking WHERE tracking_property = ?");

			$q->bindValue(1,$_GET['id']);

			$q ->execute();

		}

		catch (PDOException $e) {echo 'Error !'; exit();}

		if($q->rowCount() > 0)

		{

			while($p = $q->fetch(PDO::FETCH_ASSOC))

			{

				array_push($_SESSION['tracks'],$p['tracking_code']);

			}

		}

	}

	

	$_SESSION['success'] = 'Property saved !';

	

	if($_FILES['property_map_images']['name'][0] != '')

	{

		require_once 'upload.php';

		upload(array('image/jpeg','image/png','image/gif'),'property_map_images','../p',$_GET['id'].'_map');

	}

	if($_FILES['property_images']['name'][0] != '')

	{

		require_once 'upload.php';

		upload(array('image/jpeg','image/png','image/gif'),'property_images','../p',$_GET['id']);

	}

	if($_FILES['property_floor_plan']['name'][0] != '')

	{

		require_once 'upload.php';

		upload(array('image/jpeg','image/png','image/gif'),'property_floor_plan','../p',$_GET['id'].'_floor');

	}

	

	if(isset($_POST['save_property_here'])) {r('p=properties&do=edit&id='.$_GET['id']);} else {r('p=properties');}

}





########################################################### Import Properties ##########################################################

if(isset($_POST['import']))

{

	if(isset($_POST['import_url']) && filter_var($_POST['import_url'], FILTER_VALIDATE_URL))

	{

		$file_ext = explode('.',$_POST['import_url']);

		$file_ext = end($file_ext);

		if($file_ext != 'zip' || get_headers($_POST['import_url'])[8] != 'Content-Type: application/zip')

		{

			$_SESSION['error'] = 'Invalid file type. Please make sure that the uploaded file is a Zip archive.';

			r('p=properties&do=import');

		}

		else

		{

			file_put_contents('p/p.zip',url_get_contents($_POST['import_url']));

		}

	}

	elseif(isset($_POST['import_url']) && file_exists('../'.$_POST['import_url']))

	{

		$file_ext = explode('.',$_POST['import_url']);

		$file_ext = end($file_ext);

		if($file_ext != 'zip' || get_headers('http://'.$domain.'/'.$_POST['import_url'])[8] != 'Content-Type: application/zip')

		{

			$_SESSION['error'] = 'Invalid file type. Please make sure that the uploaded file is a Zip archive.';

			r('p=properties&do=import');

		}

		else

		{

			copy('../'.$_POST['import_url'],'../admin/p/p.zip');

		}

	}

	elseif(isset($_FILES['import_file']) && !empty($_FILES['import_file']))

	{

		$file_ext = explode('.',$_FILES['import_file']['name']);

		$file_ext = end($file_ext);

		if($file_ext != 'zip' || $_FILES['import_file']['type'] != 'application/zip')

		{

			$_SESSION['error'] = 'Invalid file type. Please make sure that the uploaded file is a Zip archive.';

			r('p=properties&do=import');

		}

		move_uploaded_file($_FILES['import_file']['tmp_name'], 'p/p.zip');

	}

	else

	{

		$_SESSION['error'] = 'You must select a file or an url for import !';

	}

	

	if(file_exists('p/p.zip'))

	{

		$zip = new ZipArchive;

		$res = $zip->open('p/p.zip');

		if($res === TRUE)

		{

			$zip->extractTo('p/');

			$zip->close();

		}

		else

		{

			system('unzip p/p.zip');

		}

		if(count(scandir('p/')) < 4)

		{

			$_SESSION['error'] = 'The zip file seems to be empty. Please try again or contact webmaster !'; r('p=properties&do=import');

		}

		

		$i = 0;

		// Open p folder

		if($folders = opendir('p'))

		{

			while(false !== ($folders_entry = readdir($folders)))

			{

				if($folders_entry != "." && $folders_entry != ".." && $folders_entry != "p.zip")

				{

					$i++;

					rename('p/'.$folders_entry,'p/'.$i);

					// Open folders from p

					if($files = opendir('p/'.$i))

					{

						while (false !== ($files_entry = readdir($files)))

						{

							$file_ext = explode('.',$files_entry);

							$file_ext = end($file_ext);

							if($file_ext == 'txt')

							{

								rename('p/'.$i.'/'. $files_entry,'p/'.$i.'/content.txt');

							}

						}

					}

					closedir($files);

				}

			}

			closedir($folders);

		}

	}

	foreach(range(1,$i) as $folder)

	{

		if(file_exists('p/'.$folder.'/content.txt'))

		{

			$property_fields = url_get_contents('http://'.$domain.'/admin/p/'.$folder.'/content.txt');

			foreach(preg_split("/((\r?\n)|(\r\n?))/", $property_fields) as $field){

				if(substr($field,0,35) == 'Plz                             :  ')

				{

					$p['property_detail_post_code'] = str_replace(substr($field,0,35),'',$field);

				}

				elseif(substr($field,0,35) == 'Ort                             :  ')

				{

					$p['property_detail_city'] = str_replace(substr($field,0,35),'',$field);

				}

				elseif(substr($field,0,35) == 'Strabe                          :  ')

				{

					$p['property_detail_street'] = str_replace(substr($field,0,35),'',$field);

				}

				elseif(substr($field,0,35) == 'Strabe nr                       :  ')

				{

					$p['property_detail_street_nr'] = str_replace(substr($field,0,35),'',$field);

				}

				elseif(substr($field,0,35) == 'Kaufpreis                       :  ')

				{

					$p['property_price'] = str_replace(substr($field,0,35),'',$field);

				}

				elseif(substr($field,0,35) == 'Wohnflache                      :  ')

				{

					$p['property_detail_size'] = str_replace(substr($field,0,35),'',$field);

				}

				elseif(substr($field,0,35) == 'Zimmer                          :  ')

				{

					$p['property_detail_rooms'] = str_replace(substr($field,0,35),'',$field);

				}

				elseif(substr($field,0,35) == 'Wohnugstyp                      :  ')

				{

					$p['property_detail_type'] = str_replace(substr($field,0,35),'',$field);

				}

				elseif(substr($field,0,35) == 'Etage                           :  ')

				{

					$p['property_detail_floor'] = str_replace(substr($field,0,35),'',$field);

				}

				elseif(substr($field,0,35) == 'Etagezahl                       :  ')

				{

					$p['property_detail_floors'] = str_replace(substr($field,0,35),'',$field);

				}

				elseif(substr($field,0,35) == 'Schlafzimmer                    :  ')

				{

					$p['property_detail_bedrooms'] = str_replace(substr($field,0,35),'',$field);

				}

				elseif(substr($field,0,35) == 'Badezimmer                      :  ')

				{

					$p['property_detail_bathrooms'] = str_replace(substr($field,0,35),'',$field);

				}

				elseif(substr($field,0,35) == 'Balkon terrasse                 :  ')

				{

					$p['property_detail_balcony_terrace'] = 'Yes';

				}

				elseif(substr($field,0,35) == 'Keller                          :  ')

				{

					$p['property_detail_basement'] = 'Yes';

				}

				elseif(substr($field,0,35) == 'Personenaufzug                  :  ')

				{

					$p['property_detail_elevator'] = 'Yes';

				}

				elseif(substr($field,0,35) == 'Garage stellplatz               :  ')

				{

					$p['property_detail_garage'] = str_replace(substr($field,0,35),'',$field);

				}

				elseif(substr($field,0,35) == 'Baujahr                         :  ')

				{

					$p['property_detail_year_built'] = str_replace(substr($field,0,35),'',$field);

				}

				elseif(substr($field,0,35) == 'Letzte modernisierung sanierung :  ')

				{

					$p['property_detail_renovated'] = str_replace(substr($field,0,35),'',$field);

				}

			}

			$p['property_name'] = $p['property_detail_title'] = 'Property for sale in: '.$p['property_detail_street'].' '.$p['property_detail_street_nr'].' - '.$p['property_detail_city'].' '.$p['property_detail_post_code'];

			$p['property_tracking'] = substr(time(),2) + $i;

			$p['property_status'] = 'hidden';

			$p['property_type'] = '0';

			$p['property_default'] = '0';

			try

			{

				$q = $pdo->prepare("INSERT INTO properties ( property_detail_post_code, property_detail_city, property_detail_street, property_detail_street_nr, property_price, property_detail_size, property_detail_rooms, property_detail_type, property_detail_floor, property_detail_floors, property_detail_bedrooms, property_detail_bathrooms, property_detail_balcony_terrace, property_detail_basement, property_detail_elevator, property_detail_garage, property_detail_year_built, property_detail_renovated, property_name, property_detail_title, property_tracking, property_status, property_type, property_default ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");

				$q->bindValue(1,''.@$p['property_detail_post_code']);

				$q->bindValue(2,''.@$p['property_detail_city']);

				$q->bindValue(3,''.@$p['property_detail_street']);

				$q->bindValue(4,''.@$p['property_detail_street_nr']);

				$q->bindValue(5,''.@$p['property_price']);

				$q->bindValue(6,''.@$p['property_detail_size']);

				$q->bindValue(7,''.@$p['property_detail_rooms']);

				$q->bindValue(8,''.@$p['property_detail_type']);

				$q->bindValue(9,''.@$p['property_detail_floor']);

				$q->bindValue(10,''.@$p['property_detail_floors']);

				$q->bindValue(11,''.@$p['property_detail_bedrooms']);

				$q->bindValue(12,''.@$p['property_detail_bathrooms']);

				$q->bindValue(13,''.@$p['property_detail_balcony_terrace']);

				$q->bindValue(14,''.@$p['property_detail_basement']);

				$q->bindValue(15,''.@$p['property_detail_elevator']);

				$q->bindValue(16,''.@$p['property_detail_garage']);

				$q->bindValue(17,''.@$p['property_detail_year_built']);

				$q->bindValue(18,''.@$p['property_detail_renovated']);

				$q->bindValue(19,''.@$p['property_name']);

				$q->bindValue(20,''.@$p['property_detail_title']);

				$q->bindValue(21,''.@$p['property_tracking']);

				$q->bindValue(22,''.@$p['property_status']);

				$q->bindValue(23,''.@$p['property_type']);

				$q->bindValue(24,''.@$p['property_default']);

				$q ->execute();

			}

			catch (PDOException $e) {echo 'Error !'.$e; exit();}

			$id = $pdo->lastInsertId();

			$img_nr = 0;

			if($files = opendir('p/'.$folder))

			{

				while (false !== ($files_entry = readdir($files)))

				{

					$file_ext = explode('.',$files_entry);

					$file_ext = end($file_ext);

					if($file_ext == 'jpg')

					{

						$img_nr++;

						$img = @imagecreatefromstring(url_get_contents('http://'.$domain.'/admin/p/'.$folder.'/'.$files_entry));

						imagealphablending($img, false);

						imagesavealpha($img, true);

						if(substr($files_entry,0,3) == 'DCM')

						{

							imagepng($img, '../p/'.$id.'_'.($img_nr).'.png');

						}

						else

						{

							imagepng($img, '../p/'.$id.'_floor_'.($img_nr).'.png');

						}

					}

				}

			}

		}

		else

		{

			$_SESSION["error"] = "One or more properties was not imported. Can't find txt file in folder !";

		}

	}

	

	function Delete($path)

	{

		if (is_dir($path) === true)

		{

			$files = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($path), RecursiveIteratorIterator::CHILD_FIRST);



			foreach ($files as $file)

			{

				if (in_array($file->getBasename(), array('.', '..')) !== true)

				{

					if ($file->isDir() === true)

					{

						rmdir($file->getPathName());

					}



					else if (($file->isFile() === true) || ($file->isLink() === true))

					{

						unlink($file->getPathname());

					}

				}

			}

		}

		else if ((is_file($path) === true) || (is_link($path) === true))

		{

			return unlink($path);

		}

		return false;

	}

	Delete('p/');

	

	if(!isset($_SESSION["error"]))

	{

		$_SESSION['success'] = 'Properties imported successfully !';

	}

	r('p=properties');

}



########################################################### Delete Properties ##########################################################

if(@$_GET['do'] == 'delete')

{

	$id = substr($_GET['id'],0,-1);

	try

	{

		$q = $pdo->prepare("DELETE FROM properties WHERE property_id IN ($id)");

		$q ->execute();

	}

	catch (PDOException $e) {echo 'Error !'; exit();}

	if($q->rowCount() == 0)

	{

		$_SESSION['error'] = 'There was an error. Please try again or contact webmaster !'; r('p=properties');

	}

	elseif($q->rowCount() > 0)

	{

		if($q->rowCount() == 0)

		{

			$_SESSION['success'] = 'The property has been deleted.';

		}

		else

		{

			$_SESSION['success'] = 'The properties have been deleted.';

		}

		

		try

		{

			$q = $pdo->prepare("SELECT tracking_code FROM tracking WHERE tracking_property IN ($id)");

			$q ->execute();

		}

		catch (PDOException $e) {echo 'Error !'; exit();}

		echo $q->rowCount();

		if($q->rowCount() > 0)

		{

			while($t = $q->fetch(PDO::FETCH_ASSOC))

			{

				$exist = array(

					'../t/Earnest-Money-Deposit-details-'.$t['tracking_code'].'.png',

					'../t/Agreement-'.$t['tracking_code'].'-part-1.png',

					'../t/Agreement-'.$t['tracking_code'].'-part-2.png',

					'../t/Agreement-'.$t['tracking_code'].'-part-3.png',

					'../t/Exclusivity-contract-'.$t['tracking_code'].'-part-1.png',

					'../t/Exclusivity-contract-'.$t['tracking_code'].'-part-2.png',

					'../t/Earnest-Money-Deposit-details-'.$t['tracking_code'].'.pdf',

					'../t/Agreement-'.$t['tracking_code'].'-part-1.pdf',

					'../t/Agreement-'.$t['tracking_code'].'-part-2.pdf',

					'../t/Agreement-'.$t['tracking_code'].'-part-3.pdf',

					'../t/Exclusivity-contract-'.$t['tracking_code'].'-part-1.pdf',

					'../t/Exclusivity-contract-'.$t['tracking_code'].'-part-2.pdf',

					'../t/Agreement-and-EMD-details-'. $t['tracking_code'].'.zip'

				);

				foreach($exist as $file)

				{

					if(file_exists($file)) {unlink($file);}

				}

			}

		}

		try

		{

			$q = $pdo->prepare("DELETE FROM tracking WHERE tracking_property IN ($id)");

			$q ->execute();

		}

		catch (PDOException $e) {echo 'Error !'; exit();}

	}

	

	$id = explode(',',$id);

	foreach($id as $property_id)

	{

		foreach(range(1,100) as $i)

		{

			if(file_exists('../p/'.$property_id.'_'.$i.'.jpg'))

			{

				unlink('../p/'.$property_id.'_'.$i.'.jpg');

			}

			if(file_exists('../p/'.$property_id.'_'.$i.'.png'))

			{

				unlink('../p/'.$property_id.'_'.$i.'.png');

			}

			if(file_exists('../p/'.$property_id.'_floor_'.$i.'.png'))

			{

				unlink('../p/'.$property_id.'_floor_'.$i.'.png');

			}

			if(file_exists('../p/'.$property_id.'_map_'.$i.'.png'))

			{

				unlink('../p/'.$property_id.'_map_'.$i.'.png');

			}

		}

		

		if(file_exists($property_id.'.zip'))

		{

			unlink($property_id.'.zip');

		}

	}

	r('p=properties');

}



############################################################ Add tracking ##############################################################

if(isset($_POST['add_track']))

{

	$tracking_code = time();

	$tracking_code = substr($tracking_code,2);

	$_POST['tracking_language'] = implode(',',$_POST['tracking_language']);

	

	if(!isset($_POST['tracking_owner_agreement'])) {$_POST['tracking_owner_agreement'] = 0;}

	if(!isset($_POST['tracking_owner_passport'])) {$_POST['tracking_owner_passport'] = 0;}

	

	try

	{

		$q = $pdo->prepare("INSERT INTO tracking (tracking_first_name, tracking_last_name, tracking_company, tracking_address, tracking_city, tracking_postal_code, tracking_country, tracking_phone, tracking_email, tracking_code, tracking_property,tracking_language,tracking_owner_agreement,tracking_owner_passport,tracking_status) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");

		$q->bindValue(1,$_POST['tracking_first_name']);

		$q->bindValue(2,$_POST['tracking_last_name']);

		$q->bindValue(3,$_POST['tracking_company']);

		$q->bindValue(4,$_POST['tracking_address']);

		$q->bindValue(5,$_POST['tracking_city']);

		$q->bindValue(6,$_POST['tracking_postal_code']);

		$q->bindValue(7,$_POST['tracking_country']);

		$q->bindValue(8,$_POST['tracking_phone']);

		$q->bindValue(9,$_POST['tracking_email']);

		$q->bindValue(10,$tracking_code);

		$q->bindValue(11,$_POST['add_track']);

		$q->bindValue(12,$_POST['tracking_language']);

		$q->bindValue(13,$_POST['tracking_owner_agreement']);

		$q->bindValue(14,$_POST['tracking_owner_passport']);

		$q->bindValue(15,'Pending');

		$q ->execute();

	}

	catch (PDOException $e) {echo 'Error !'.$e; exit();}

	

	if($q->rowCount() == 1)

	{

		$_SESSION['success'] = 'Track added !';

	}

	else

	{

		$_SESSION['error'] = 'There was an error. Please try again or contact webmaster !';

	}

	array_push($_SESSION['tracks'],$tracking_code);

	r('p=properties');

}





############################################################ Save tracking #############################################################

if(isset($_POST['save_track']))

{

	$_POST['tracking_language'] = implode(',',$_POST['tracking_language']);

	

	if(!isset($_POST['tracking_owner_agreement'])) {$_POST['tracking_owner_agreement'] = 0;}

	if(!isset($_POST['tracking_owner_passport'])) {$_POST['tracking_owner_passport'] = 0;}

	

	try

	{

		$q = $pdo->prepare("UPDATE tracking SET tracking_first_name = ?, tracking_last_name = ?, tracking_company = ?, tracking_address = ?, tracking_city = ?, tracking_postal_code = ?, tracking_country = ?, tracking_phone = ?, tracking_email = ?, tracking_language = ?, tracking_owner_agreement = ?, tracking_owner_passport = ? WHERE tracking_id = ?");

		$q->bindValue(1,$_POST['tracking_first_name']);

		$q->bindValue(2,$_POST['tracking_last_name']);

		$q->bindValue(3,$_POST['tracking_company']);

		$q->bindValue(4,$_POST['tracking_address']);

		$q->bindValue(5,$_POST['tracking_city']);

		$q->bindValue(6,$_POST['tracking_postal_code']);

		$q->bindValue(7,$_POST['tracking_country']);

		$q->bindValue(8,$_POST['tracking_phone']);

		$q->bindValue(9,$_POST['tracking_email']);

		$q->bindValue(10,$_POST['tracking_language']);

		$q->bindValue(11,$_POST['tracking_owner_agreement']);

		$q->bindValue(12,$_POST['tracking_owner_passport']);

		$q->bindValue(13,$_POST['tracking_id']);

		$q ->execute();

	}

	catch (PDOException $e) {echo 'Error !'.$e; exit();}

	

	if($q->rowCount() == 0 || $q->rowCount() == 1)

	{

		$_SESSION['success'] = 'Track saved !';

	}

	else

	{

		$_SESSION['error'] = 'There was an error. Please try again or contact webmaster !';

	}

	array_push($_SESSION['tracks'],$_POST['tracking_code']);

	r('p=properties');

}



######################################################### Delete tracking ##############################################################

if(@$_GET['do'] == 'delete-tracking')

{

	try

	{

		$q = $pdo->prepare("DELETE FROM tracking WHERE tracking_code = ?");

		$q->bindValue(1,$_GET['id']);

		$q ->execute();

	}

	catch (PDOException $e) {echo 'Error !'; exit();}

	if($q->rowCount() != 1)

	{

		$_SESSION['error'] = 'There was an error. Please try again or contact webmaster !';

	}

	else

	{

		$exist = array(

			'../t/Earnest-Money-Deposit-details-'.$_GET['id'].'.png',

			'../t/Agreement-'.$_GET['id'].'-part-1.png',

			'../t/Agreement-'.$_GET['id'].'-part-2.png',

			'../t/Agreement-'.$_GET['id'].'-part-3.png',

			'../t/Agreement-'.$_GET['id'].'-part-4.png',

			'../t/Earnest-Money-Deposit-details-'.$_GET['id'].'.pdf',

			'../t/Agreement-'.$_GET['id'].'-part-1.pdf',

			'../t/Agreement-'.$_GET['id'].'-part-2.pdf',

			'../t/Agreement-'.$_GET['id'].'-part-3.pdf',

			'../t/Agreement-'.$_GET['id'].'-part-4.pdf',

			'../t/Agreement-and-EMD-details-'. $_GET['id'].'.zip'

		);

		foreach($exist as $file)

		{

			if(file_exists($file)) {unlink($file);}

		}

		$_SESSION['success'] = 'Track deleted.';

	}

	$_SESSION['delete-track'] = $_GET['property-id'];

	r('p=properties');

}

